# Imports
import asyncio
import os
import json
import traceback

from pylog.pylogger import PyLogger

from py_pli.pylib import VUnits
from py_pli.pylib import send_msg
from py_pli.pylib import GlobalVar
from predefined_tasks.common.helper import send_to_gc

PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]

# Logging and Messages
logger = PyLogger.logger
error_msg = f"Error Predefined Tasks in {BASE_NAME}."
start_msg = f"Start Predefined Task {BASE_NAME}."
info_msg = f"Information from {BASE_NAME}."
stop_msg = f"Stopped Predefined Task {BASE_NAME}."
complete_msg = f"Completed Predefined Task {BASE_NAME}."

async def il_switch_test(cycles = 1, open_time_s = 120, closed_time_s = 5, profile = 1):
    """Interlock Test 
    Requirements: MMDHLS-28

    This test verifies the interlock functionality of the system. It checks that
    certain operations are blocked when specific conditions are not met, ensuring
    the safety and integrity of the system.

    Preconditions:
        - The system is powered on and initialized.
        - All necessary components are connected and functional.
    """
    # Open Plate Door
    # Wait open_time seconds
    # Close plate door
    # wait closed_time secs
    # repeat cycles times

    logger.info(start_msg)
    await send_to_gc(start_msg)

    plate_door = VUnits.instance.hal.plateDoor
    await plate_door.Home()
    await plate_door.UseProfile(profile)
    await plate_door.Close()
    for i in range(cycles):
        if GlobalVar.get_stop_gc():
                    logger.error(stop_msg)
                    await send_to_gc(stop_msg)
                    return 
        msg = f"{info_msg} Cycle {i+1}/{cycles}"
        logger.info(msg)
        await send_to_gc(msg)
        try:
            # Open Plate Door
            await plate_door.Open()
            msg = f"{info_msg} Plate Door open, waiting {open_time_s} seconds."
            logger.info(msg)
            await send_to_gc(msg)

            await asyncio.sleep(open_time_s)

            # Close Plate Door
            await plate_door.Close()
            msg = f"{info_msg} Plate Door closed, waiting {closed_time_s} seconds."
            logger.info(msg)
            await send_to_gc(msg)

            await asyncio.sleep(closed_time_s)

        except Exception as e:
            logger.error(f"{error_msg} Cycle {i+1}/{cycles}: {str(e)}")
            traceback.print_exc()
        
    await plate_door.Close()
    await send_to_gc(complete_msg)
    logger.info(complete_msg)